/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.impl;

import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class SimpleIterator
implements Iterator {
    private List source;
    private int nextIndex = 0;

    public SimpleIterator(List source) {
        this.source = source;
    }

    public boolean hasNext() {
        return this.nextIndex < this.source.size();
    }

    public Object next() {
        if (this.nextIndex == this.source.size()) {
            throw new NoSuchElementException("Cannot retrieve element " + this.nextIndex + " on a list of size " + this.source.size());
        }
        Object result = this.source.get(this.nextIndex);
        ++this.nextIndex;
        return result;
    }

    public void remove() {
        if (this.nextIndex == 0) {
            throw new IllegalStateException("Cannot remove() without a prior call to next() or previous()");
        }
        this.source.remove(this.nextIndex - 1);
        --this.nextIndex;
    }
}

