/*
 * Decompiled with CFR 0.152.
 */
package com.loomcom.ant.tasks.jarbundler;

import com.loomcom.ant.tasks.jarbundler.AppBundleProperties;
import com.loomcom.ant.tasks.jarbundler.PropertyListWriter;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.FileScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.FileList;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.PatternSet;
import org.apache.tools.ant.util.FileUtils;

public class JarBundler
extends MatchingTask {
    private static final String DEFAULT_STUB = "/System/Library/Frameworks/JavaVM.framework/Versions/Current/Resources/MacOS/JavaApplicationStub";
    private static final String DEFAULT_CHMOD = "/bin/chmod";
    private File mAppIcon;
    private File mRootDir;
    private List mJarFileSets = new ArrayList();
    private List mExecFileSets = new ArrayList();
    private List mExtraClassPathFileSets = new ArrayList();
    private List mJarFileLists = new ArrayList();
    private List mExecFileLists = new ArrayList();
    private List mExtraClassPathFileLists = new ArrayList();
    private List mJarAttrs = new ArrayList();
    private List mExecAttrs = new ArrayList();
    private List mExtraClassPathAttrs = new ArrayList();
    private boolean mVerbose = false;
    private File mStubFile = new File("/System/Library/Frameworks/JavaVM.framework/Versions/Current/Resources/MacOS/JavaApplicationStub");
    private String mAboutMenuName;
    private boolean mSmallTabs = false;
    private boolean mAntiAliasedGraphics = false;
    private boolean mAntiAliasedText = false;
    private boolean mLiveResize = false;
    private boolean mScreenMenuBar = false;
    private boolean mGrowbox = true;
    private boolean mGrowboxIntrudes = false;
    private File mContentsDir;
    private File mMacOsDir;
    private File mJavaDir;
    private String mChmodCommand = "/bin/chmod";
    private AppBundleProperties mProps = new AppBundleProperties();
    private FileUtils mFileUtils = FileUtils.newFileUtils();

    public void execute() throws BuildException {
        if (this.mRootDir == null) {
            throw new BuildException("Required attribute \"dir\" is not set.");
        }
        if (this.mJarAttrs.isEmpty() && this.mJarFileSets.isEmpty() && this.mJarFileLists.isEmpty()) {
            throw new BuildException("Either the attribute \"jars\" must be set, or one or more jarfilelists or jarfilesets must be added.");
        }
        if (!(this.mJarAttrs.isEmpty() || this.mJarFileSets.isEmpty() && this.mJarFileLists.isEmpty())) {
            throw new BuildException("Cannot set both the attribute \"jars\" and use jar filesets/filelists.  Use only one or the other.");
        }
        if (this.mProps.getCFBundleName() == null) {
            throw new BuildException("Required attribute \"name\" is not set.");
        }
        if (this.mProps.getMainClass() == null) {
            throw new BuildException("Required attribute \"mainclass\" is not set.");
        }
        if (this.mAboutMenuName == null) {
            this.mAboutMenuName = this.mProps.getCFBundleName();
        }
        this.mProps.addJavaProperty("com.apple.mrj.application.apple.menu.about.name", this.mAboutMenuName);
        this.mProps.addJavaProperty("com.apple.smallTabs", new Boolean(this.mSmallTabs).toString());
        String antiAliasedProperty = this.useOldPropertyNames() ? "com.apple.macosx.AntiAliasedGraphicsOn" : "apple.awt.antialiasing";
        this.mProps.addJavaProperty(antiAliasedProperty, new Boolean(this.mAntiAliasedGraphics).toString().toString());
        String antiAliasedTextProperty = this.useOldPropertyNames() ? "com.apple.macosx.AntiAliasedTextOn" : "apple.awt.textantialiasing";
        this.mProps.addJavaProperty(antiAliasedTextProperty, new Boolean(this.mAntiAliasedText).toString());
        this.mProps.addJavaProperty("com.apple.mrj.application.live-resize", new Boolean(this.mLiveResize).toString());
        String screenMenuBarProperty = this.useOldPropertyNames() ? "com.apple.macos.useScreenMenuBar" : "apple.laf.useScreenMenuBar";
        this.mProps.addJavaProperty(screenMenuBarProperty, new Boolean(this.mScreenMenuBar).toString());
        if (!this.useOldPropertyNames()) {
            this.mProps.addJavaProperty("apple.awt.showGrowBox", new Boolean(this.mGrowbox).toString());
        }
        if (this.useOldPropertyNames()) {
            this.mProps.addJavaProperty("com.apple.mrj.application.growbox.intrudes", new Boolean(this.mGrowboxIntrudes).toString());
        }
        if (!this.mRootDir.exists() || this.mRootDir.exists() && !this.mRootDir.isDirectory()) {
            throw new BuildException("Destination directory specified by \"dir\" attribute must already exist.");
        }
        File bundleDir = new File(this.mRootDir, this.mProps.getCFBundleName() + ".app");
        if (bundleDir.exists()) {
            throw new BuildException("The App Bundle " + bundleDir.getName() + " already exists, cannot continue.");
        }
        System.out.println("Creating application bundle " + bundleDir);
        if (!bundleDir.mkdir()) {
            throw new BuildException("Unable to create bundle: " + bundleDir);
        }
        this.mContentsDir = new File(bundleDir, "Contents");
        if (!this.mContentsDir.mkdir()) {
            throw new BuildException("Unable to create directory " + this.mContentsDir);
        }
        this.mMacOsDir = new File(this.mContentsDir, "MacOS");
        if (!this.mMacOsDir.mkdir()) {
            throw new BuildException("Unable to create directory " + this.mMacOsDir);
        }
        File resourceDir = new File(this.mContentsDir, "Resources");
        if (!resourceDir.mkdir()) {
            throw new BuildException("Unable to create directory " + resourceDir);
        }
        this.mJavaDir = new File(resourceDir, "Java");
        if (!this.mJavaDir.mkdir()) {
            throw new BuildException("Unable to create directory " + this.mJavaDir);
        }
        if (this.mAppIcon != null) {
            try {
                this.mFileUtils.copyFile(this.mAppIcon, new File(resourceDir, this.mAppIcon.getName()));
            }
            catch (IOException ex) {
                throw new BuildException("Cannot copy icon file: " + ex);
            }
        }
        this.processJarAttrs();
        this.processJarFileSets();
        this.processJarFileLists();
        this.processExecAttrs();
        this.processExecFileSets();
        this.processExecFileLists();
        this.processExtraClassPathAttrs();
        this.processExtraClassPathFileSets();
        this.processExtraClassPathFileLists();
        this.copyApplicationStub();
        this.writeInfoPlist();
        this.writePkgInfo();
    }

    public void addJarfileset(FileSet fs) {
        this.mJarFileSets.add(fs);
    }

    public void addJarfilelist(FileList fl) {
        this.mJarFileLists.add(fl);
    }

    public void addExecfileset(FileSet fs) {
        this.mExecFileSets.add(fs);
    }

    public void addExecfilelist(FileList fl) {
        this.mExecFileLists.add(fl);
    }

    public void addExtraclasspathfileset(FileSet fs) {
        this.mExtraClassPathFileSets.add(fs);
    }

    public void addExtraclasspathfilelist(FileList fl) {
        this.mExtraClassPathFileLists.add(fl);
    }

    public void setArguments(String s) {
        this.mProps.setArguments(s);
    }

    public void setStubFile(File f) {
        this.mStubFile = f;
    }

    public void setDir(File f) {
        this.mRootDir = f;
    }

    public void setName(String s) {
        this.mProps.setCFBundleName(s);
    }

    public void setMainClass(String s) {
        this.mProps.setMainClass(s);
    }

    public void setWorkingDirectory(String s) {
        this.mProps.setWorkingDirectory(s);
    }

    public void setIcon(File f) {
        this.mAppIcon = f;
        this.mProps.setCFBundleIconFile(f.getName());
    }

    public void setBundleid(String s) {
        this.mProps.setCFBundleIdentifier(s);
    }

    public void setDevelopmentregion(String s) {
        this.mProps.setCFBundleDevelopmentRegion(s);
    }

    public void setAboutmenuname(String s) {
        this.mAboutMenuName = s;
    }

    public void setSmallTabs(boolean b) {
        this.mSmallTabs = b;
    }

    public void setVmoptions(String s) {
        this.mProps.setVMOptions(s);
    }

    public void setAntialiasedgraphics(boolean b) {
        this.mAntiAliasedGraphics = b;
    }

    public void setAntialiasedtext(boolean b) {
        this.mAntiAliasedText = b;
    }

    public void setScreenmenu(boolean b) {
        this.mScreenMenuBar = b;
    }

    public void setGrowbox(boolean b) {
        this.mGrowbox = b;
    }

    public void setGrowboxintrudes(boolean b) {
        this.mGrowboxIntrudes = b;
    }

    public void setLiveresize(boolean b) {
        this.mLiveResize = b;
    }

    public void setType(String s) {
        this.mProps.setCFBundlePackageType(s);
    }

    public void setSignature(String s) {
        this.mProps.setCFBundleSignature(s);
    }

    public void setJvmversion(String s) {
        this.mProps.setJVMVersion(s);
    }

    public void setInfostring(String s) {
        this.mProps.setCFBundleGetInfoString(s);
    }

    public void setVerbose(boolean b) {
        this.mVerbose = b;
    }

    public void setVersion(String s) {
        this.mProps.setCFBundleVersion(s);
    }

    public void setJars(String s) {
        PatternSet patset = new PatternSet();
        patset.setIncludes(s);
        String[] jarNames = patset.getIncludePatterns(this.getProject());
        for (int i = 0; i < jarNames.length; ++i) {
            File f = new File(jarNames[i]);
            this.mJarAttrs.add(f);
        }
    }

    public void setExecs(String s) {
        PatternSet patset = new PatternSet();
        patset.setIncludes(s);
        String[] execNames = patset.getIncludePatterns(this.getProject());
        for (int i = 0; i < execNames.length; ++i) {
            File f = new File(execNames[i]);
            this.mExecAttrs.add(f);
        }
    }

    public void setExtraclasspath(String s) {
        PatternSet patset = new PatternSet();
        patset.setIncludes(s);
        String[] cpNames = patset.getIncludePatterns(this.getProject());
        for (int i = 0; i < cpNames.length; ++i) {
            File f = new File(cpNames[i]);
            this.mExtraClassPathAttrs.add(f);
        }
    }

    public void setChmod(String s) {
        this.mChmodCommand = s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setExecutable(File f) throws IOException {
        InputStream es;
        block9: {
            String filePath = f.getAbsolutePath();
            File test = new File(this.mChmodCommand);
            if (!test.exists()) {
                return;
            }
            if (this.mVerbose) {
                System.out.println("Setting file " + f + " executable.");
            }
            Process p = Runtime.getRuntime().exec(new String[]{this.mChmodCommand, "a+x", filePath});
            InputStream is = null;
            es = null;
            try {
                is = p.getInputStream();
                es = p.getErrorStream();
                byte[] buf = new byte[1024];
                int len = 0;
                while ((len = is.read(buf)) != -1) {
                    System.out.write(buf, 0, len);
                }
                while ((len = es.read(buf)) != -1) {
                    System.out.write(buf, 0, len);
                }
                Object var10_9 = null;
                if (is == null) break block9;
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                if (is != null) {
                    is.close();
                }
                if (es != null) {
                    es.close();
                }
                throw throwable;
            }
            is.close();
        }
        if (es != null) {
            es.close();
        }
    }

    private boolean useOldPropertyNames() {
        return this.mProps.getJVMVersion().startsWith("1.3");
    }

    private void processJarAttrs() throws BuildException {
        try {
            Iterator jarIter = this.mJarAttrs.iterator();
            while (jarIter.hasNext()) {
                File src = (File)jarIter.next();
                File dest = new File(this.mJavaDir, src.getName());
                if (this.mVerbose) {
                    System.out.println("Copying from " + src + " to " + dest);
                }
                this.mFileUtils.copyFile(src, dest);
                this.mProps.addToClassPath(dest.getName());
            }
        }
        catch (IOException ex) {
            throw new BuildException("Cannot copy jar file: " + ex);
        }
    }

    private void processJarFileSets() throws BuildException {
        Iterator jarIter = this.mJarFileSets.iterator();
        while (jarIter.hasNext()) {
            FileSet fs = (FileSet)jarIter.next();
            Project p = fs.getProject();
            File srcDir = fs.getDir(p);
            DirectoryScanner ds = fs.getDirectoryScanner(p);
            fs.setupDirectoryScanner((FileScanner)ds, p);
            ds.scan();
            String[] files = ds.getIncludedFiles();
            try {
                for (int i = 0; i < files.length; ++i) {
                    String fileName = files[i];
                    File src = new File(srcDir, fileName);
                    File dest = new File(this.mJavaDir, fileName);
                    if (this.mVerbose) {
                        System.out.println("Copying from " + src + " to " + dest);
                    }
                    this.mFileUtils.copyFile(src, dest);
                    this.mProps.addToClassPath(fileName);
                }
            }
            catch (IOException ex) {
                throw new BuildException("Cannot copy jar file: " + ex);
            }
        }
    }

    private void processJarFileLists() throws BuildException {
        Iterator jarIter = this.mJarFileLists.iterator();
        while (jarIter.hasNext()) {
            FileList fl = (FileList)jarIter.next();
            Project p = fl.getProject();
            File srcDir = fl.getDir(p);
            String[] files = fl.getFiles(p);
            try {
                for (int i = 0; i < files.length; ++i) {
                    String fileName = files[i];
                    File src = new File(srcDir, fileName);
                    File dest = new File(this.mJavaDir, fileName);
                    if (this.mVerbose) {
                        System.out.println("Copying from " + src + " to " + dest);
                    }
                    this.mFileUtils.copyFile(src, dest);
                    this.mProps.addToClassPath(fileName);
                }
            }
            catch (IOException ex) {
                throw new BuildException("Cannot copy jar file: " + ex);
            }
        }
    }

    private void processExtraClassPathAttrs() throws BuildException {
        Iterator jarIter = this.mExtraClassPathAttrs.iterator();
        while (jarIter.hasNext()) {
            File src = (File)jarIter.next();
            this.mProps.addToExtraClassPath(src.getPath());
        }
    }

    private void processExtraClassPathFileSets() throws BuildException {
        Iterator jarIter = this.mExtraClassPathFileSets.iterator();
        while (jarIter.hasNext()) {
            FileSet fs = (FileSet)jarIter.next();
            Project p = fs.getProject();
            File srcDir = fs.getDir(p);
            DirectoryScanner ds = fs.getDirectoryScanner(p);
            fs.setupDirectoryScanner((FileScanner)ds, p);
            ds.scan();
            String[] files = ds.getIncludedFiles();
            for (int i = 0; i < files.length; ++i) {
                File f = new File(srcDir, files[i]);
                this.mProps.addToExtraClassPath(f.getPath());
            }
        }
    }

    private void processExtraClassPathFileLists() throws BuildException {
        Iterator jarIter = this.mExtraClassPathFileLists.iterator();
        while (jarIter.hasNext()) {
            FileList fl = (FileList)jarIter.next();
            Project p = fl.getProject();
            File srcDir = fl.getDir(p);
            String[] files = fl.getFiles(p);
            for (int i = 0; i < files.length; ++i) {
                File f = new File(srcDir, files[i]);
                this.mProps.addToExtraClassPath(f.getPath());
            }
        }
    }

    private void processExecAttrs() throws BuildException {
        try {
            Iterator execIter = this.mExecAttrs.iterator();
            while (execIter.hasNext()) {
                File src = (File)execIter.next();
                File dest = new File(this.mMacOsDir, src.getName());
                if (this.mVerbose) {
                    System.out.println("Copying from " + src + " to " + dest);
                }
                this.mFileUtils.copyFile(src, dest);
                this.setExecutable(dest);
            }
        }
        catch (IOException ex) {
            throw new BuildException("Cannot copy exec file: " + ex);
        }
    }

    private void processExecFileSets() {
        Iterator execIter = this.mExecFileSets.iterator();
        while (execIter.hasNext()) {
            FileSet fs = (FileSet)execIter.next();
            Project p = fs.getProject();
            File srcDir = fs.getDir(p);
            DirectoryScanner ds = fs.getDirectoryScanner(p);
            fs.setupDirectoryScanner((FileScanner)ds, p);
            ds.scan();
            String[] files = ds.getIncludedFiles();
            try {
                for (int i = 0; i < files.length; ++i) {
                    String fileName = files[i];
                    File src = new File(srcDir, fileName);
                    File dest = new File(this.mMacOsDir, fileName);
                    if (this.mVerbose) {
                        System.out.println("Copying from " + src + " to " + dest);
                    }
                    this.mFileUtils.copyFile(src, dest);
                    this.setExecutable(dest);
                }
            }
            catch (IOException ex) {
                throw new BuildException("Cannot copy exec file: " + ex);
            }
        }
    }

    private void processExecFileLists() throws BuildException {
        Iterator execIter = this.mExecFileLists.iterator();
        while (execIter.hasNext()) {
            FileList fl = (FileList)execIter.next();
            Project p = fl.getProject();
            File srcDir = fl.getDir(p);
            String[] files = fl.getFiles(p);
            try {
                for (int i = 0; i < files.length; ++i) {
                    String fileName = files[i];
                    File src = new File(srcDir, fileName);
                    File dest = new File(this.mMacOsDir, fileName);
                    if (this.mVerbose) {
                        System.out.println("Copying from " + src + " to " + dest);
                    }
                    this.mFileUtils.copyFile(src, dest);
                    this.setExecutable(dest);
                }
            }
            catch (IOException ex) {
                throw new BuildException("Cannot copy jar file: " + ex);
            }
        }
    }

    private void copyApplicationStub() throws BuildException {
        if (this.mVerbose) {
            System.out.println("Copying JavaApplicationStub...");
        }
        File newStubFile = new File(this.mMacOsDir, "JavaApplicationStub");
        try {
            this.mFileUtils.copyFile(this.mStubFile, newStubFile);
        }
        catch (IOException ex) {
            throw new BuildException("Cannot copy JavaApplicationStub: " + ex);
        }
        try {
            this.setExecutable(newStubFile);
        }
        catch (IOException ex) {
            throw new BuildException("Cannot set executable bit: " + ex);
        }
    }

    private void writeInfoPlist() throws BuildException {
        PropertyListWriter listWriter = new PropertyListWriter(this.mProps);
        File infoPlist = new File(this.mContentsDir, "Info.plist");
        listWriter.writeFile(infoPlist);
    }

    private void writePkgInfo() throws BuildException {
        File pkgInfo = new File(this.mContentsDir, "PkgInfo");
        PrintWriter pkgWriter = null;
        try {
            pkgWriter = new PrintWriter(new BufferedWriter(new FileWriter(pkgInfo)));
            pkgWriter.println(this.mProps.getCFBundlePackageType() + this.mProps.getCFBundleSignature());
            pkgWriter.flush();
        }
        catch (IOException ex) {
            throw new BuildException("Cannot create PkgInfo file: " + ex);
        }
        finally {
            if (pkgWriter != null) {
                pkgWriter.close();
            }
        }
    }
}

